///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MaxSchedules 10

//-------------------------------------------

char *WeekDayName[7] = {
    "Sunday",
    "Monday",
    "Tuesday",
    "Wedensday",
    "Thursday",
    "Friday",
    "Saturday"
};

//-------------------------------------------

struct _Schedule{
    char *Name;
    char *Filename;
    char *Description;

    char *SQLServer;
    char *Database;
    char *DBDriver;
    char *Username;
    char *Password;
    BOOL IsTrusted;

    BOOL WeekDays[7];

    DWORD BackupWindowTimeBegin;
    DWORD BackupWindowTimeEnd;
    DWORD StartOnceTime;
    DWORD NextRunTime; // Do not save to file... Calculate at startup.

    DWORD LastRunTime;
    DWORD LastRunDate;

    DWORD ScheduleID;

    WORD IncrementHour;
    WORD IncrementMinute;

    BOOL OnlyRunOnce;
    BOOL OnHold;
    BOOL Active;
    BOOL ScheduleSet;
}; _Schedule *Sched;

int NumberOfSetSchedules = 0;
DWORD CurrentScheduleID  = 0;

//-------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetWeekDay(void)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return ST.wDayOfWeek;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetNextRunDay(int xItem)
{
    int WeekDay = GetWeekDay(); // WeekDay = today

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    DWORD CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    // If we only run once per day and the run once time is passed. Increment one day past today.
    if(Sched[xItem].OnlyRunOnce == TRUE)
    {
        if(CurrentTime >= Sched[xItem].StartOnceTime)
            WeekDay++;
    }

    if(WeekDay > 6) WeekDay = 0;

    // If we only more than once per day and the end window time is passed. Increment one day past today.
    if(Sched[xItem].OnlyRunOnce == FALSE)
    {
        if(CurrentTime >= Sched[xItem].BackupWindowTimeEnd)
            WeekDay++;
    }

    if(WeekDay > 6) WeekDay = 0;

     // This loop will hang the application if no run days are checked
    while(TRUE)
    {
        if( Sched[xItem].WeekDays[WeekDay] == TRUE )
            return WeekDay;

    	if(WeekDay > 6)
            WeekDay = -1;

        WeekDay++;
    }

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void GetNextOperation(int xItem, char *Return)
{
    SYSTEMTIME ST;

    GetSystemTime(&ST);

    char TimeTemp[64];

    int Hour, Minute, Second;

    if(Sched[xItem].OnlyRunOnce == TRUE)
        LongToTime(Sched[xItem].StartOnceTime, &Hour, &Minute, &Second); // StartOnceTime
    else LongToTime(Sched[xItem].NextRunTime, &Hour, &Minute, &Second); // NextRunTime

    ST.wHour   = Hour;
    ST.wMinute = Minute;
    ST.wSecond = Second;

    GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &ST, NULL, TimeTemp, 56);

    sprintf(Return, "%s - %s", WeekDayName[ GetNextRunDay(xItem) ], TimeTemp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadWeekDaysFromScheduleItemIntoDialog(HWND xDialog, int ThisItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if(Sched[ThisItem].WeekDays[MainLoop] == TRUE)
            CheckDlgButton(xDialog, 1000 + MainLoop, BST_CHECKED);
        else CheckDlgButton(xDialog, 1000 + MainLoop, BST_UNCHECKED);

        MainLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NumberOfDaysChecked(int ThisItem)
{
    int MainLoop = 0;
    int Checked  = 0;

    while(MainLoop < 7)
    {
        if( Sched[ThisItem].WeekDays[MainLoop] == TRUE)
            Checked++;

        MainLoop++;
    }

    return Checked;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL IsAtleastOneDayChecked(HWND xDialog)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( IsDlgButtonChecked(xDialog, 1000 + MainLoop) )
            return TRUE;

        MainLoop++;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL IsAtleastOneDaySelected(int xItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( Sched[xItem].WeekDays[MainLoop] == TRUE )
            return TRUE;

        MainLoop++;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadWeekDaysFromDialogIntoScheduleItem(HWND xDialog, int ThisItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( IsDlgButtonChecked(xDialog, 1000 + MainLoop) == TRUE)
            Sched[ThisItem].WeekDays[MainLoop] = TRUE;
        else Sched[ThisItem].WeekDays[MainLoop] = FALSE;

        MainLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadScheduleIntoDialog(void)
{
    int LocalLoop = 0;

	while(LocalLoop < MaxSchedules)
	{
        if(Sched[LocalLoop].ScheduleSet == TRUE)
        {
            char ID[16];
            char NextOperation[256];

            sprintf(ID, "%d", Sched[LocalLoop].ScheduleID);
            GetNextOperation(LocalLoop, NextOperation);

            SD.LVItem.pszText  = ID;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 0;
            ListView_InsertItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = Sched[LocalLoop].Name;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 1;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = Sched[LocalLoop].Description;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 2;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = NextOperation;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 3;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = Sched[LocalLoop].Database;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 4;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

        	SD.LVItem.pszText  = Sched[LocalLoop].Filename;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 5;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);
        }

        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ScheduleIDToPosition(DWORD ItemID)
{
    int LocalLoop = 0;
	while(LocalLoop < MaxSchedules)
	{
        if(Sched[LocalLoop].ScheduleID == ItemID)
            return LocalLoop;

        LocalLoop++;
    }
    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void EndScheduleByID(DWORD ItemID)
{
    int LocalLoop = 0;
	while(LocalLoop < MaxSchedules)
	{
        if(Sched[LocalLoop].ScheduleID == ItemID)
        {
            Sched[LocalLoop].ScheduleSet = FALSE;
            break;
        }
        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void InitSchedule(void)
{
    int LocalLoop = 0;

    Sched = (_Schedule *) calloc( sizeof(_Schedule), MaxSchedules);

    while(LocalLoop < MaxSchedules)
    {
        Sched[LocalLoop].Name                  = NULL;
        Sched[LocalLoop].Filename              = NULL;
        Sched[LocalLoop].Description           = NULL;

        Sched[LocalLoop].SQLServer             = NULL;
        Sched[LocalLoop].Database              = NULL;
        Sched[LocalLoop].DBDriver              = NULL;
        Sched[LocalLoop].Username              = NULL;
        Sched[LocalLoop].Password              = NULL;

        Sched[LocalLoop].IsTrusted             = FALSE;

        Sched[LocalLoop].BackupWindowTimeBegin = 0;
        Sched[LocalLoop].BackupWindowTimeEnd   = 0;

        Sched[LocalLoop].ScheduleID            = 0;

        Sched[LocalLoop].IncrementHour         = 0;
        Sched[LocalLoop].IncrementMinute       = 0;

        Sched[LocalLoop].OnlyRunOnce           = FALSE;
        Sched[LocalLoop].OnHold                = FALSE;
        Sched[LocalLoop].Active                = FALSE;
        Sched[LocalLoop].ScheduleSet           = FALSE;

        LocalLoop++;
    }

    NumberOfSetSchedules = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NextAvailSchedule(void)
{
    int LocalLoop = 0;

    while(LocalLoop < MaxSchedules)
    {
        if(Sched[LocalLoop].ScheduleSet == FALSE)
            return LocalLoop;

        LocalLoop++;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IncrementTheTime(DWORD CurrentTime,  int xItem)
{
    // If the job only runs on one day per week and its now past the time window end.
    if(NumberOfDaysChecked(xItem) == 1 && CurrentTime > Sched[xItem].BackupWindowTimeEnd)
    {
        // Set the NextRunTime to the BackupWindowTimeBegin
        Sched[xItem].NextRunTime = Sched[xItem].BackupWindowTimeBegin;
        return 0;
    }

    // If thje next run day is not today
    if(GetNextRunDay(xItem) != GetWeekDay())
    {
        // Set the NextRunTime to the BackupWindowTimeBegin
        Sched[xItem].NextRunTime = Sched[xItem].BackupWindowTimeBegin;
        return 0;
    }

    // If the CurrentTime is past the jobs NextRunTime
    while(Sched[xItem].NextRunTime <= CurrentTime)
    {
        // Perform a full increment on the NextRunTime
        Sched[xItem].NextRunTime = (Sched[xItem].NextRunTime + ((Sched[xItem].IncrementMinute * 60) + ((Sched[xItem].IncrementHour * 60) * 60)));
    }

    if(Sched[xItem].NextRunTime > 86399)
    {
        Sched[xItem].NextRunTime = ((Sched[xItem].NextRunTime - 86399) - 1);
    }

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CalculateSchedules(void)
{
    SYSTEMTIME ST;

    GetLocalTime(&ST);

    DWORD CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    int LocalLoop = 0;
    while(LocalLoop < MaxSchedules)
    {
        // If the schedule is set and it runs multiple times per day
        if(Sched[LocalLoop].ScheduleSet == TRUE && Sched[LocalLoop].OnlyRunOnce == FALSE)
        {
            // Set the NextRunTime to the BackupWindowTimeBegin
            Sched[LocalLoop].NextRunTime = Sched[LocalLoop].BackupWindowTimeBegin;

            // Now increment the schedule
            IncrementTheTime(CurrentTime, LocalLoop);
        }

        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CheckSchedule(void)
{
    SYSTEMTIME ST;

    int LocalLoop     = 0;
    DWORD CurrentDate = 0;
    DWORD CurrentTime = 0;

    if(CurrentlyRunning == TRUE)
        return -1;

    GetLocalTime(&ST);

    CurrentDate = DateToLong(ST.wYear, ST.wMonth,  ST.wDay);
    CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    while(LocalLoop < MaxSchedules)
    {
        if(Sched[LocalLoop].ScheduleSet == TRUE && Sched[LocalLoop].Active == TRUE)
        {
//          if(Sched[LocalLoop].WeekDays[ST.wDayOfWeek] == TRUE)
            if(GetNextRunDay(LocalLoop) == ST.wDayOfWeek)
            {
               // If job only runs once on scheduled days
                if(Sched[LocalLoop].OnlyRunOnce == TRUE)
                {
                    if(CurrentDate != Sched[LocalLoop].LastRunDate)
                    {
                        if( CurrentTime >= Sched[LocalLoop].StartOnceTime )
                        {
                            Sched[LocalLoop].LastRunTime = CurrentTime;
                            Sched[LocalLoop].LastRunDate = CurrentDate;
                            return LocalLoop;
                        }
                    }
                }

                // if job runs multiple times on scheduled days
                if(Sched[LocalLoop].OnlyRunOnce == FALSE)
                {
                    /*
                        If the backup BackupWindowTimeEnd is 5:00 and we check the schdule at 5:00.01
                            then the backup will be skipped. Therfor were going to try to make the time
                            window 60 seconds longer. This should now be fixed. 5/30/2003 2:53:30 PM

                        This did not work. If the last job ran at 5:00 and the backup took less than one minute,
                        The job would run twice. Try one second instead. 6/3/2003 10:10:00 AM

                    */


                    // If we missed our last backup then increment the time
                    if( (CurrentTime >= (Sched[LocalLoop].BackupWindowTimeEnd + 1)) && CurrentTime > Sched[LocalLoop].NextRunTime)
                    {
                        IncrementTheTime(CurrentTime, LocalLoop);
                    }

                    /*
                        If the backup BackupWindowTimeEnd is 5:00 and we check the schdule at 5:00.01
                            then the backup will be skipped. Therfor were going to try to make the time
                            window 60 seconds longer. This should now be fixed. 5/30/2003 2:57:08 PM

                        This did not work. If the last job ran at 5:00 and the backup took less than one minute,
                        The job would run twice. Try one second instead. 6/3/2003 10:10:00 AM

                    */


                    if( (CurrentTime >= Sched[LocalLoop].BackupWindowTimeBegin) && (CurrentTime <= (Sched[LocalLoop].BackupWindowTimeEnd + 1)) )
                    {
                        if(CurrentTime >= Sched[LocalLoop].NextRunTime)
                        {
                            IncrementTheTime(CurrentTime, LocalLoop);
                            Sched[LocalLoop].LastRunTime = CurrentTime;
                            Sched[LocalLoop].LastRunDate = CurrentDate;
                            return LocalLoop;
                        }
                    }
                }
                //-----------------------------------------------
            }
        }

        LocalLoop++;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

